/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.fuel;

import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.fuel.IFluidContainer;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelLookup;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;

public class MeltingFuel
implements ICustomOutputRecipe<IFluidContainer> {
    private final class_2960 id;
    private final String group;
    private final FluidIngredient input;
    private final int duration;
    private final int temperature;

    public MeltingFuel(class_2960 id, String group, FluidIngredient input, int duration, int temperature) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.duration = duration;
        this.temperature = temperature;
        for (FluidStack fluid : input.getFluids()) {
            MeltingFuelLookup.addFuel(fluid.getFluid(), this);
        }
    }

    public boolean matches(IFluidContainer inv, class_1937 worldIn) {
        return this.matches(inv.getFluid());
    }

    public boolean matches(class_3611 fluid) {
        return this.input.test(fluid);
    }

    public long getAmount(IFluidContainer inv) {
        return this.getAmount(inv.getFluid());
    }

    public long getAmount(class_3611 fluid) {
        return this.input.getAmount(fluid);
    }

    public List<FluidStack> getInputs() {
        return this.input.getFluids();
    }

    public class_3956<?> method_17716() {
        return (class_3956)TinkerRecipeTypes.FUEL.get();
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerSmeltery.fuelSerializer.get();
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)TinkerSmeltery.searedTank.get(SearedTankBlock.TankType.FUEL_TANK));
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public String method_8112() {
        return this.group;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<MeltingFuel> {
        public MeltingFuel fromJson(class_2960 id, JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            FluidIngredient input = FluidIngredient.deserialize(json, "fluid");
            int duration = class_3518.method_15260((JsonObject)json, (String)"duration");
            int temperature = class_3518.method_15260((JsonObject)json, (String)"temperature");
            return new MeltingFuel(id, group, input, duration, temperature);
        }

        @Override
        protected void toNetworkSafe(class_2540 buffer, MeltingFuel recipe) {
            buffer.method_10814(recipe.group);
            recipe.input.write(buffer);
            buffer.writeInt(recipe.duration);
            buffer.writeInt(recipe.temperature);
        }

        @Override
        @Nullable
        protected MeltingFuel fromNetworkSafe(class_2960 id, class_2540 buffer) {
            String group = buffer.method_10800(Short.MAX_VALUE);
            FluidIngredient input = FluidIngredient.read(buffer);
            int duration = buffer.readInt();
            int temperature = buffer.readInt();
            return new MeltingFuel(id, group, input, duration, temperature);
        }
    }
}

